import { View, Text, FlatList, Pressable } from "react-native";
import { useState, useEffect } from "react";
import styles from "./CustomerGalleryStyles";
import { useNavigation } from "@react-navigation/native";
import { ratingAndReviewsStyle } from "../../../../../screens/Home/FeaturedProducts/ProductDetails/RatingAndReviews/RatingAndReviewsStyle";
import ReviewImages from "../../../../../screens/Home/FeaturedProducts/ProductDetails/RatingAndReviews/ReviewImages";
import useLangTranslation from "../../../../../hooks/useLangTranslation";

const CustomerGallery = ({vendorProductReviews}) => {
	const { trans } = useLangTranslation();
	const navigation = useNavigation();
	const [galleryImages, setGalleryImages] = useState([]);

	useEffect(() => {
		const images = vendorProductReviews.map((item) => {
			return item.image.map((image) => {
				return  image ;
			});
		});
		const flattenImages = images.flat();
		setGalleryImages(flattenImages);
	}, [vendorProductReviews])

	if(galleryImages?.length === 0) return null;

	return (
		<View style={styles}>
			<View style={styles.header}>
				<Text style={styles.title}>{trans("Customer Gallery")}</Text>
				<Text style={styles.title}>({galleryImages?.length})</Text>
			</View>
			 <View
					style={
						ratingAndReviewsStyle.reviewImgCont
					}
				>
					{galleryImages?.length > 5 && (
						<Pressable
							style={
								ratingAndReviewsStyle.imageSeeAll
							}
							onPress={() =>
								navigation.navigate(
									"reviewImageGallery",
									{
										images: galleryImages,
									}
								)
							}
						>
							<Text
								style={
									ratingAndReviewsStyle.imageSeeAllText
								}
							>
								{trans("See All")}
							</Text>
						</Pressable>
					)}
					<FlatList
						data={galleryImages}
						keyExtractor={(_, index) =>
							"key" + index
						}
						renderItem={(image, index) => (
							<ReviewImages
								image={image.item}
								index={index}
								data={galleryImages}
								imageStyle={
									ratingAndReviewsStyle.reviewImg
								}
							/>
						)}
						horizontal
						scrollEnabled={false}
						showsHorizontalScrollIndicator={
							false
						}
					/>
				</View>
		</View>
	);
};

export default CustomerGallery;
